/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.views;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.fieldgroup.PropertyId;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.DateField;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import fr.univlorraine.fwa.controllers.FwaAppController;
import fr.univlorraine.fwa.entities.FwaApp;
import fr.univlorraine.fwa.entities.FwaApp_;
import fr.univlorraine.fwa.utils.Utils;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import ru.xpoft.vaadin.VaadinView;

@Component
@Scope(value="prototype")
@VaadinView(value="applicationView")
public class ApplicationView
extends HorizontalSplitPanel
implements View {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "applicationView";
    private final Log logger = LogFactory.getLog(this.getClass());
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient FwaAppController appController;
    private BeanItemContainer<FwaApp> appContainer;
    private BeanItem<FwaApp> selectedAppItem;
    private static final String LIB_APP = FwaApp_.libApp.getName();
    private static final String TES_APP = FwaApp_.tesApp.getName();
    private static final String DAT_DEB_CLO_APP = FwaApp_.datDebCloApp.getName();
    private static final String DAT_FIN_CLO_APP = FwaApp_.datFinCloApp.getName();
    private static final Object[] APP_VISIBLE_COLUMNS = new Object[]{LIB_APP, TES_APP, DAT_DEB_CLO_APP, DAT_FIN_CLO_APP};
    private static String SIMPLEDATF = "dd/MM/yyyy HH:mm";
    @Value(value="${base.temoinEnService}")
    private transient char TES;
    @Value(value="${base.temoinPasService}")
    private transient char TPS;
    private Label titre = new Label();
    private Label selectMsg = new Label();
    private VerticalLayout tablelayout = new VerticalLayout();
    private Table applicationTable;
    private VerticalLayout detailsLayout = new VerticalLayout();
    private FormLayout fieldGroupLayout = new FormLayout();
    private FieldGroup fieldGroup;
    private Label titreLayout = new Label();
    @PropertyId(value="datDebCloApp")
    private DateField dateDebutField = new DateField();
    @PropertyId(value="datFinCloApp")
    private DateField dateFinField = new DateField();
    private CheckBox checkbox = new CheckBox();
    private HorizontalLayout buttonsLayout = new HorizontalLayout();
    private Button saveBtn = new Button();
    private Button deleteBtn = new Button();
    private ThemeResource addIcon = new ThemeResource("icons/disk.png");
    private ThemeResource deleteIcon = new ThemeResource("icons/delete.png");

    @PostConstruct
    public void init() {
        this.setSplitPosition(620.0f, Sizeable.Unit.PIXELS);
        this.setLocked(true);
        this.setWidth(1000.0f, Sizeable.Unit.PIXELS);
        this.setHeight(350.0f, Sizeable.Unit.PIXELS);
        this.tablelayout.setMargin(new MarginInfo(true, true, false, true));
        this.tablelayout.setSpacing(true);
        this.titre.setCaption(this.applicationContext.getMessage("applicationView.titre", null, Locale.getDefault()));
        this.titre.addStyleName("h2");
        this.tablelayout.addComponent((com.vaadin.ui.Component)this.titre);
        this.applicationTable = Utils.createCustomTable((String)SIMPLEDATF);
        this.applicationTable.setImmediate(true);
        this.applicationTable.setSelectable(true);
        this.applicationTable.setPageLength(10);
        this.applicationTable.setWidth("540");
        this.appContainer = this.appController.getApps();
        this.customTable();
        this.applicationTable.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tablelayout.addComponent((com.vaadin.ui.Component)this.applicationTable);
        this.selectMsg = new Label(this.applicationContext.getMessage("applicationView.select.msg", null, Locale.getDefault()));
        this.selectMsg.setStyleName("middlePage");
        this.detailsLayout.setMargin(true);
        this.detailsLayout.setSpacing(true);
        this.detailsLayout.addComponent((com.vaadin.ui.Component)this.selectMsg);
        this.titreLayout.setCaption(this.applicationContext.getMessage("applicationView.detail.titre", null, Locale.getDefault()));
        this.titreLayout.addStyleName("h2");
        this.dateDebutField.setImmediate(true);
        this.dateDebutField.setResolution(Resolution.MINUTE);
        this.dateDebutField.setDateFormat(SIMPLEDATF);
        this.dateDebutField.setCaption(this.applicationContext.getMessage("applicationView.date.debut", null, Locale.getDefault()));
        this.dateDebutField.setParseErrorMessage(this.applicationContext.getMessage("applicationView.date.error.format", null, Locale.getDefault()));
        this.dateDebutField.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dateFinField.setImmediate(true);
        this.dateFinField.setResolution(Resolution.MINUTE);
        this.dateFinField.setDateFormat(SIMPLEDATF);
        this.dateFinField.setCaption(this.applicationContext.getMessage("applicationView.date.fin", null, Locale.getDefault()));
        this.dateFinField.setParseErrorMessage(this.applicationContext.getMessage("applicationView.date.error.format", null, Locale.getDefault()));
        this.dateFinField.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldGroup = new BeanFieldGroup(FwaApp.class);
        this.fieldGroup.bindMemberFields((Object)this);
        this.checkbox.setCaption(this.applicationContext.getMessage("applicationView.activate", null, Locale.getDefault()));
        this.checkbox.setImmediate(true);
        this.checkbox.addValueChangeListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.saveBtn.setIcon((com.vaadin.server.Resource)this.addIcon);
        this.saveBtn.setCaption(this.applicationContext.getMessage("applicationView.save", null, Locale.getDefault()));
        this.saveBtn.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteBtn.setIcon((com.vaadin.server.Resource)this.deleteIcon);
        this.deleteBtn.setCaption(this.applicationContext.getMessage("applicationView.delete", null, Locale.getDefault()));
        this.deleteBtn.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldGroupLayout.setMargin(false);
        this.fieldGroupLayout.setSpacing(true);
        this.fieldGroupLayout.addComponent((com.vaadin.ui.Component)this.dateDebutField);
        this.fieldGroupLayout.addComponent((com.vaadin.ui.Component)this.dateFinField);
        this.fieldGroupLayout.addComponent((com.vaadin.ui.Component)this.checkbox);
        this.buttonsLayout.setMargin(true);
        this.buttonsLayout.setSpacing(true);
        this.buttonsLayout.addComponent((com.vaadin.ui.Component)this.saveBtn);
        this.buttonsLayout.addComponent((com.vaadin.ui.Component)this.deleteBtn);
    }

    private void customTable() {
        this.applicationTable.setContainerDataSource((Container)this.appContainer);
        this.applicationTable.setVisibleColumns(APP_VISIBLE_COLUMNS);
        String[] columnHeaders = new String[APP_VISIBLE_COLUMNS.length];
        for (int columnIndex = 0; columnIndex < APP_VISIBLE_COLUMNS.length; ++columnIndex) {
            columnHeaders[columnIndex] = this.applicationContext.getMessage("applicationView.table." + APP_VISIBLE_COLUMNS[columnIndex], null, Locale.getDefault());
        }
        this.applicationTable.setColumnHeaders(columnHeaders);
    }

    protected void createDetailslayout() {
        this.fieldGroup.setItemDataSource((Item)this.selectedAppItem);
        if (((FwaApp)this.selectedAppItem.getBean()).getTesApp() == this.TES) {
            this.checkbox.setValue((Object)true);
        } else {
            this.checkbox.setValue((Object)false);
        }
        this.detailsLayout.addComponent((com.vaadin.ui.Component)this.titreLayout);
        this.detailsLayout.addComponent((com.vaadin.ui.Component)this.fieldGroupLayout);
        this.detailsLayout.addComponent((com.vaadin.ui.Component)this.buttonsLayout);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.setFirstComponent((com.vaadin.ui.Component)this.tablelayout);
        this.setSecondComponent((com.vaadin.ui.Component)this.detailsLayout);
    }

    static /* synthetic */ Table access$000(ApplicationView x0) {
        return x0.applicationTable;
    }

    static /* synthetic */ BeanItem access$102(ApplicationView x0, BeanItem x1) {
        x0.selectedAppItem = x1;
        return x0.selectedAppItem;
    }

    static /* synthetic */ BeanItemContainer access$200(ApplicationView x0) {
        return x0.appContainer;
    }

    static /* synthetic */ VerticalLayout access$300(ApplicationView x0) {
        return x0.detailsLayout;
    }

    static /* synthetic */ BeanItem access$100(ApplicationView x0) {
        return x0.selectedAppItem;
    }

    static /* synthetic */ Button access$400(ApplicationView x0) {
        return x0.deleteBtn;
    }

    static /* synthetic */ Label access$500(ApplicationView x0) {
        return x0.selectMsg;
    }

    static /* synthetic */ DateField access$600(ApplicationView x0) {
        return x0.dateDebutField;
    }

    static /* synthetic */ DateField access$700(ApplicationView x0) {
        return x0.dateFinField;
    }

    static /* synthetic */ CheckBox access$800(ApplicationView x0) {
        return x0.checkbox;
    }

    static /* synthetic */ char access$900(ApplicationView x0) {
        return x0.TES;
    }

    static /* synthetic */ char access$1000(ApplicationView x0) {
        return x0.TPS;
    }

    static /* synthetic */ ApplicationContext access$1100(ApplicationView x0) {
        return x0.applicationContext;
    }

    static /* synthetic */ FieldGroup access$1200(ApplicationView x0) {
        return x0.fieldGroup;
    }

    static /* synthetic */ Log access$1300(ApplicationView x0) {
        return x0.logger;
    }

    static /* synthetic */ FwaAppController access$1400(ApplicationView x0) {
        return x0.appController;
    }

    static /* synthetic */ BeanItemContainer access$202(ApplicationView x0, BeanItemContainer x1) {
        x0.appContainer = x1;
        return x0.appContainer;
    }

    static /* synthetic */ void access$1500(ApplicationView x0) {
        x0.customTable();
    }
}

