/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.utils;

import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;

public class FWAFilterBasedLdapUserSearch
implements LdapUserSearch {
    private static final Log logger = LogFactory.getLog(FilterBasedLdapUserSearch.class);
    private ContextSource contextSource;
    private SearchControls searchControls = new SearchControls();
    private String searchBase = "";
    private String ldapOu;
    private String ldapUid;

    public FWAFilterBasedLdapUserSearch(String searchBase, String ldapOu, String ldapUid, BaseLdapPathContextSource contextSource) {
        this.searchBase = searchBase;
        this.ldapOu = ldapOu;
        this.ldapUid = ldapUid;
        this.contextSource = contextSource;
        this.setSearchSubtree(true);
        if (searchBase.length() == 0) {
            logger.info((Object)("SearchBase not set. Searches will be performed from the root: " + contextSource.getBaseLdapPath()));
        }
    }

    public DirContextOperations searchForUser(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for user '" + username + "', with user search " + this));
        }
        boolean trouve = false;
        DirContextOperations result = null;
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(this.contextSource);
        template.setSearchControls(this.searchControls);
        ArrayList<String> listOu = new ArrayList<String>();
        DirContext ctx = this.contextSource.getReadOnlyContext();
        try {
            NamingEnumeration<SearchResult> results = ctx.search(this.searchBase, this.ldapOu, this.searchControls);
            while (results != null && results.hasMore()) {
                SearchResult sr = results.next();
                listOu.add(sr.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            logger.debug((Object)("Erreur dans la recherche des 'ou' " + e.getMessage()));
        }
        Iterator it = listOu.iterator();
        while (it.hasNext() && !trouve) {
            Object current = it.next();
            try {
                result = template.searchForSingleEntry(current.toString(), this.ldapUid, (Object[])new String[]{username});
                trouve = result != null;
            }
            catch (IncorrectResultSizeDataAccessException notFound) {
                if (notFound.getActualSize() == 0) {
                    trouve = false;
                    continue;
                }
                throw notFound;
            }
        }
        if (!trouve) {
            throw new UsernameNotFoundException("Utilisateur " + username + " non trouv\u00e9.", (Object)username);
        }
        return result;
    }

    public void setDerefLinkFlag(boolean deref) {
        this.searchControls.setDerefLinkFlag(deref);
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchControls.setSearchScope(searchSubtree ? 2 : 1);
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchControls.setTimeLimit(searchTimeLimit);
    }

    public void setReturningAttributes(String[] attrs) {
        this.searchControls.setReturningAttributes(attrs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ searchFilteNiv1: '").append(this.ldapOu).append("', ");
        sb.append("[ searchFilteNiv2: '").append(this.ldapUid).append("', ");
        sb.append("searchBase: '").append(this.searchBase).append("'");
        sb.append(", scope: ").append(this.searchControls.getSearchScope() == 2 ? "subtree" : "single-level, ");
        sb.append(", searchTimeLimit: ").append(this.searchControls.getTimeLimit());
        sb.append(", derefLinkFlag: ").append(this.searchControls.getDerefLinkFlag()).append(" ]");
        return sb.toString();
    }
}

