/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.repositories;

import com.ibm.icu.text.Transliterator;
import fr.univlorraine.fwa.entities.FwaApp;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NameAlreadyBoundException;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.stereotype.Repository;

@Repository
public class OidRepository {
    private final Log logger = LogFactory.getLog(this.getClass());

    public String getGUID(String login, LdapTemplate oidTemplate) {
        DistinguishedName dn = new DistinguishedName();
        dn.add("cn", "Users");
        dn.add("cn", login);
        String res = "";
        try {
            String[] guid = (String[])oidTemplate.lookup((Name)dn, new String[]{"orclguid"}, (ContextMapper)new /* Unavailable Anonymous Inner Class!! */);
            if (guid != null && guid.length > 0) {
                res = guid[0];
            }
        }
        catch (NameNotFoundException e) {
            this.logger.error((Object)("getGUID : orcguid non trouv\u00e9 => " + (Object)((Object)e)));
        }
        return res;
    }

    public void bindUser(String login, String nom, String prenom, String mail, LdapTemplate oidTemplate) {
        DistinguishedName dn = new DistinguishedName();
        dn.add("cn", "Users");
        dn.add("cn", login);
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute ocattr = new BasicAttribute("objectclass");
        ocattr.add("person");
        ocattr.add("organizationalPerson");
        ocattr.add("inetOrgPerson");
        ocattr.add("top");
        ocattr.add("orcluser");
        ocattr.add("orcluserv2");
        attrs.put(ocattr);
        if (mail != null) {
            attrs.put("mail", mail);
        }
        attrs.put("cn", login);
        attrs.put("sn", nom);
        Transliterator accentsconverter = Transliterator.getInstance((String)"NFD;  [:M:] Remove; NFC");
        prenom = accentsconverter.transliterate(prenom);
        attrs.put("givenname", prenom);
        attrs.put("uid", login);
        try {
            oidTemplate.bind((Name)dn, null, (Attributes)attrs);
        }
        catch (NameAlreadyBoundException e) {
            this.logger.debug((Object)("bindRAD : L'objet " + dn.toUrl() + " existe d\u00e9j\u00e0\u00a0"));
        }
    }

    public void unbindUser(String login, LdapTemplate oidTemplate) {
        DistinguishedName dn = new DistinguishedName();
        dn.add("cn", "Users");
        dn.add("cn", login);
        try {
            oidTemplate.unbind((Name)dn);
        }
        catch (NameNotFoundException e) {
            this.logger.debug((Object)("unbindUser : L'objet " + dn.toUrl() + " n'existe pas"));
        }
    }

    public void bindRAD(String login, String guid, String dbuser, String dbpwd, String formsId, String tnsname, String resourcename, String usermodifiable, LdapTemplate oidTemplate) throws InvalidNameException {
        DistinguishedName entryDn = new DistinguishedName();
        entryDn.add("cn", "OracleContext");
        entryDn.add("cn", "Extended Properties");
        entryDn.add("orclownerguid", guid);
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute ocattr = new BasicAttribute("objectclass");
        ocattr.add("top");
        ocattr.add("orclReferenceObject");
        attrs.put(ocattr);
        attrs.put("orclownerguid", guid);
        LdapContextSource cs = (LdapContextSource)oidTemplate.getContextSource();
        String seealso = "cn=" + login + ",cn=Users," + cs.getBaseLdapPath();
        attrs.put("seealso", seealso);
        try {
            oidTemplate.bind((Name)entryDn, null, (Attributes)attrs);
            this.logger.debug((Object)("bindRAD 1: Cr\u00e9ation de l'objet " + entryDn.toUrl()));
        }
        catch (NameAlreadyBoundException e) {
            this.logger.debug((Object)("bindRAD 1: L'objet " + entryDn.toUrl() + " existe d\u00e9j\u00e0\u00a0"));
        }
        entryDn.add("cn", "Resource Access Descriptor");
        attrs = new BasicAttributes();
        ocattr = new BasicAttribute("objectclass");
        ocattr.add("top");
        ocattr.add("orclcontainer");
        ocattr.add("orclauxiliaryguid");
        attrs.put(ocattr);
        attrs.put("orclownerguid", guid);
        attrs.put("cn", "Resource Access Descriptor");
        try {
            oidTemplate.bind((Name)entryDn, null, (Attributes)attrs);
            this.logger.debug((Object)("bindRAD 2: Cr\u00e9ation de l'objet " + entryDn.toUrl()));
        }
        catch (NameAlreadyBoundException e) {
            this.logger.debug((Object)("bindRAD 2: L'objet " + entryDn.toUrl() + " existe d\u00e9j\u00e0\u00a0"));
        }
        LdapName ldapname = new LdapName(entryDn.toString());
        ldapname.add("orclresourcename=" + resourcename + "+orclresourcetypename=oracleDB");
        attrs = new BasicAttributes();
        attrs.put("orclresourcetypename", "OracleDb");
        attrs.put("orclflexattribute1", tnsname);
        attrs.put("orcluseridattribute", dbuser);
        attrs.put("orclresourceviewers", "orclApplicationCommonName=" + formsId + ", cn=forms, cn=Products, cn=OracleContext");
        attrs.put("orclownerguid", guid);
        attrs.put("orclusermodifiable", usermodifiable);
        attrs.put("orclpasswordattribute", dbpwd);
        attrs.put("orclresourcename", resourcename);
        ocattr = new BasicAttribute("objectclass");
        ocattr.add("top");
        ocattr.add("orclresourcedescriptor");
        attrs.put(ocattr);
        try {
            oidTemplate.bind((Name)ldapname, null, (Attributes)attrs);
            this.logger.debug((Object)("bindRAD 3: cr\u00e9ation de: L'objet " + ldapname.toString()));
        }
        catch (NameAlreadyBoundException e) {
            this.logger.debug((Object)("bindRAD 3: L'objet " + ldapname.toString() + " existe d\u00e9j\u00e0\u00a0"));
        }
    }

    public void unbindAllRAD(String login, List<FwaApp> listAppUti, LdapTemplate oidTemplate) throws InvalidNameException {
        String guid = this.getGUID(login, oidTemplate);
        if (guid.equals("")) {
            this.logger.debug((Object)("unbindAllRAD : Aucun guid associ\u00e9 au login " + login));
            return;
        }
        for (FwaApp app : listAppUti) {
            this.unbindRAD(login, app.getBdApp(), oidTemplate);
        }
        DistinguishedName entryDn = new DistinguishedName();
        entryDn.add("cn", "OracleContext");
        entryDn.add("cn", "Extended Properties");
        entryDn.add("orclownerguid", guid);
        entryDn.add("cn", "Resource Access Descriptor");
        try {
            oidTemplate.unbind((Name)entryDn);
        }
        catch (NameNotFoundException e) {
            this.logger.debug((Object)("unbindAllRAD : L'objet " + entryDn.toUrl() + " n'existe pas"));
        }
        entryDn = new DistinguishedName();
        entryDn.add("cn", "OracleContext");
        entryDn.add("cn", "Extended Properties");
        entryDn.add("orclownerguid", guid);
        try {
            oidTemplate.unbind((Name)entryDn);
        }
        catch (NameNotFoundException e) {
            this.logger.debug((Object)("unbindAllRAD : L'objet " + entryDn.toUrl() + " n'existe pas"));
        }
    }

    public void unbindRAD(String login, String resourcename, LdapTemplate oidTemplate) throws InvalidNameException {
        String guid = this.getGUID(login, oidTemplate);
        if (guid.equals("")) {
            this.logger.debug((Object)("unbindRAD : Aucun guid associ\u00e9 au login " + login));
            return;
        }
        DistinguishedName entryDn = new DistinguishedName();
        entryDn.add("cn", "OracleContext");
        entryDn.add("cn", "Extended Properties");
        entryDn.add("orclownerguid", guid);
        entryDn.add("cn", "Resource Access Descriptor");
        LdapName ldapname = new LdapName(entryDn.toString());
        ldapname.add("orclresourcename=" + resourcename + "+orclresourcetypename=oracleDB");
        try {
            oidTemplate.unbind((Name)ldapname);
            this.logger.debug((Object)("unbindRAD : suppression de l'objet " + ldapname.toString()));
        }
        catch (NameNotFoundException e) {
            this.logger.debug((Object)("unbindRAD : L'objet " + ldapname.toString() + " n'existe pas"));
        }
    }
}

