/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.repositories;

import fr.univlorraine.fwa.controllers.FwaUtiAttributeMapper;
import fr.univlorraine.fwa.entities.FwaUti;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.stereotype.Repository;

@Repository
public class LdapRepository {
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient LdapTemplate ldapTemplate;
    @Resource
    private LdapContextSource ldapServer;
    private final Log logger = LogFactory.getLog(this.getClass());
    @Value(value="${ldap.dc}")
    private transient String dc;
    @Value(value="${ldap.ou}")
    private transient String ou;
    @Value(value="${ldap.uid}")
    private transient String uid;
    @Value(value="${ldap.sn}")
    private transient String sn;

    public List<FwaUti> getUtiFrom(String nom, String login, String bCategories) {
        boolean trouve = false;
        AndFilter andFilter = new AndFilter();
        if (nom != null) {
            andFilter.and((Filter)new WhitespaceWildcardsFilter(this.sn, nom));
        }
        if (login != null) {
            andFilter.and((Filter)new EqualsFilter(this.uid, login));
        }
        if (bCategories != null) {
            OrFilter orfilter = new OrFilter();
            if (!bCategories.contains(",")) {
                orfilter.or((Filter)new EqualsFilter("businessCategory", bCategories.trim()));
            } else {
                for (String bc : bCategories.split(",")) {
                    orfilter.or((Filter)new EqualsFilter("businessCategory", bc.trim()));
                }
            }
            andFilter.and((Filter)orfilter);
        }
        this.logger.debug((Object)("__LDAP query " + andFilter.encode()));
        ArrayList<String> listOu = new ArrayList<String>();
        DirContext ctx = this.ldapServer.getReadOnlyContext();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> results = ctx.search(this.dc, this.ou, constraints);
            while (results != null && results.hasMore()) {
                SearchResult sr = results.next();
                listOu.add(sr.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            this.logger.debug((Object)("Erreur dans la recherche des 'ou' " + e.getMessage()));
        }
        try {
            ArrayList<FwaUti> result = new ArrayList<FwaUti>();
            for (String ou : listOu) {
                LdapName ldapname2 = new LdapName(ou);
                result.addAll(this.ldapTemplate.search((Name)ldapname2, andFilter.encode(), (AttributesMapper)new FwaUtiAttributeMapper(this.uid, this.sn)));
            }
            return result;
        }
        catch (InvalidNameException e1) {
            this.logger.debug((Object)" --- InvalidNameException --");
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public void setLdapServer(LdapContextSource ldapServer) {
        this.ldapServer = ldapServer;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public void setOu(String ou) {
        this.ou = ou;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }
}

