/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.repositories;

import fr.univlorraine.fwa.entities.FwaCpt;
import fr.univlorraine.fwa.entities.FwaCptPk;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface FwaCptRepository
extends JpaRepository<FwaCpt, FwaCptPk> {
    @Query(value="SELECT LOGIN_CPT, fwa_cpt.ID_UTI, COD_APP, AES_DECRYPT(PWD_CPT, :key) AS PWD_CPT, TES_CPT, DAT_FIN_CPT, DAT_DER_CON_CPT from  fwa_cpt where ID_UTI = :id", nativeQuery=true)
    public List<FwaCpt> findCptForUser(@Param(value="id") int var1, @Param(value="key") String var2);

    @Query(value="SELECT LOGIN_CPT, fwa_cpt.ID_UTI, COD_APP, AES_DECRYPT(PWD_CPT, :key) AS PWD_CPT, TES_CPT, DAT_FIN_CPT, DAT_DER_CON_CPT FROM fwa_cpt JOIN fwa_uti ON fwa_uti.ID_UTI = fwa_cpt.ID_UTI WHERE UPPER(LOGIN_UTI) = UPPER(:loginUti) AND LOGIN_CPT = :loginCpt AND COD_APP = :codApp", nativeQuery=true)
    public FwaCpt findOneByLoginUti(@Param(value="key") String var1, @Param(value="loginUti") String var2, @Param(value="loginCpt") String var3, @Param(value="codApp") String var4);

    @Query(value="SELECT LOGIN_CPT, fwa_cpt.ID_UTI, COD_APP, AES_DECRYPT(PWD_CPT, :key) AS PWD_CPT, TES_CPT, DAT_FIN_CPT, DAT_DER_CON_CPT FROM fwa_cpt JOIN fwa_uti ON fwa_uti.ID_UTI = fwa_cpt.ID_UTI WHERE UPPER(LOGIN_UTI) = UPPER(:login) AND COD_APP = :codApp", nativeQuery=true)
    public List<FwaCpt> findCptForUserAndApp(@Param(value="key") String var1, @Param(value="login") String var2, @Param(value="codApp") String var3);

    @Query(value="SELECT LOGIN_CPT, fwa_cpt.ID_UTI, COD_APP, AES_DECRYPT(PWD_CPT, :key) AS PWD_CPT, TES_CPT, DAT_FIN_CPT, DAT_DER_CON_CPT FROM fwa_cpt JOIN fwa_uti ON fwa_uti.ID_UTI = fwa_cpt.ID_UTI WHERE UPPER(LOGIN_UTI) = UPPER(:login) AND COD_APP = :codApp AND fwa_cpt.TES_CPT ='O' AND ( DAT_FIN_CPT IS NULL OR CURRENT_DATE <= DAT_FIN_CPT)", nativeQuery=true)
    public List<FwaCpt> findOpenCptForUserAndApp(@Param(value="key") String var1, @Param(value="login") String var2, @Param(value="codApp") String var3);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE fwa_cpt SET TES_CPT = :tes, DAT_FIN_CPT = :dateFin WHERE ID_UTI = :idUti AND COD_APP = :codApp", nativeQuery=true)
    public void updateAllCpt(@Param(value="tes") char var1, @Param(value="dateFin") Date var2, @Param(value="idUti") int var3, @Param(value="codApp") String var4);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE fwa_cpt SET DAT_FIN_CPT = :dateFin WHERE ID_UTI = :idUti AND COD_APP = :codApp", nativeQuery=true)
    public void updateAllDateCpt(@Param(value="dateFin") Date var1, @Param(value="idUti") int var2, @Param(value="codApp") String var3);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE fwa_cpt SET TES_CPT = :tes, DAT_FIN_CPT = null WHERE ID_UTI = :idUti AND COD_APP = :codApp", nativeQuery=true)
    public void updateAllCpt(@Param(value="tes") char var1, @Param(value="idUti") int var2, @Param(value="codApp") String var3);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE fwa_cpt SET DAT_FIN_CPT = null WHERE ID_UTI = :idUti AND COD_APP = :codApp", nativeQuery=true)
    public void updateAllDateCpt(@Param(value="idUti") int var1, @Param(value="codApp") String var2);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE fwa_cpt SET TES_CPT = :tes WHERE ID_UTI = :idUti AND COD_APP = :codApp", nativeQuery=true)
    public void updateAllTesCpt(@Param(value="tes") char var1, @Param(value="idUti") int var2, @Param(value="codApp") String var3);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="INSERT INTO fwa_cpt (LOGIN_CPT, ID_UTI, COD_APP, PWD_CPT, TES_CPT, DAT_FIN_CPT) VALUES (:loginCpt, :idUti, :codApp, AES_ENCRYPT(:pwdCpt, :key), :tesCpt, :dateFin)", nativeQuery=true)
    public void insertCpt(@Param(value="loginCpt") String var1, @Param(value="idUti") int var2, @Param(value="codApp") String var3, @Param(value="pwdCpt") String var4, @Param(value="key") String var5, @Param(value="tesCpt") char var6, @Param(value="dateFin") Date var7);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="INSERT INTO fwa_cpt (LOGIN_CPT, ID_UTI, COD_APP, PWD_CPT, TES_CPT, DAT_FIN_CPT) VALUES (:loginCpt, :idUti, :codApp, AES_ENCRYPT(:pwdCpt, :key), :tesCpt, null)", nativeQuery=true)
    public void insertCpt(@Param(value="loginCpt") String var1, @Param(value="idUti") int var2, @Param(value="codApp") String var3, @Param(value="pwdCpt") String var4, @Param(value="key") String var5, @Param(value="tesCpt") char var6);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="DELETE FROM fwa_cpt where LOGIN_CPT = :loginCpt AND ID_UTI = :idUti AND COD_APP = :codApp ", nativeQuery=true)
    public void deleteCpt(@Param(value="idUti") int var1, @Param(value="loginCpt") String var2, @Param(value="codApp") String var3);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="Select ID_UTI FROM fwa_cpt where ID_UTI = :idUti", nativeQuery=true)
    public Integer findOneCpt(@Param(value="idUti") int var1);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value=" UPDATE fwa_cpt SET PWD_CPT = AES_ENCRYPT(:pwdCpt, :key), TES_CPT = :tesCpt, DAT_FIN_CPT = :dateFin WHERE ID_UTI = :idUti AND LOGIN_CPT = :loginCpt AND COD_APP = :codApp", nativeQuery=true)
    public void updateCpt(@Param(value="pwdCpt") String var1, @Param(value="key") String var2, @Param(value="tesCpt") char var3, @Param(value="dateFin") Date var4, @Param(value="idUti") int var5, @Param(value="loginCpt") String var6, @Param(value="codApp") String var7);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value=" UPDATE fwa_cpt SET PWD_CPT = AES_ENCRYPT(:pwdCpt, :key), TES_CPT = :tesCpt , DAT_FIN_CPT = null WHERE ID_UTI = :idUti AND LOGIN_CPT = :loginCpt AND COD_APP = :codApp", nativeQuery=true)
    public void updateCpt(@Param(value="pwdCpt") String var1, @Param(value="key") String var2, @Param(value="tesCpt") char var3, @Param(value="idUti") int var4, @Param(value="loginCpt") String var5, @Param(value="codApp") String var6);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value=" UPDATE fwa_cpt SET DAT_DER_CON_CPT = :dateDerCon WHERE ID_UTI = :idUti AND LOGIN_CPT = :loginCpt AND COD_APP = :codApp", nativeQuery=true)
    public void update(@Param(value="dateDerCon") Date var1, @Param(value="idUti") int var2, @Param(value="loginCpt") String var3, @Param(value="codApp") String var4);
}

