/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import fr.univlorraine.fwa.controllers.FwaAdmController;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class UserController {
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient UserDetailsService userDetailsService;
    @Resource
    private transient FwaAdmController admController;

    public Authentication getCurrentAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public UserDetails getCurrentUser() {
        return (UserDetails)this.getCurrentAuthentication().getPrincipal();
    }

    public String getCurrentUserName() {
        return this.getCurrentAuthentication().getName();
    }

    public boolean isUserAdmin() {
        return this.admController.isAdmin(this.getCurrentUserName());
    }
}

