/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import fr.univlorraine.fwa.controllers.UserController;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class SessionController {
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient UserController userController;
    private List<VaadinSession> activeSessions = new CopyOnWriteArrayList();
    private static final long minCleanInterval = 5000L;
    private long lastCleanTimestamp = System.currentTimeMillis();

    public List<VaadinSession> getActiveSessions() {
        this.cleanActiveSessions();
        return this.activeSessions;
    }

    public void registerSession(VaadinSession session) {
        if (!this.activeSessions.contains(session)) {
            this.activeSessions.add(session);
            session.setAttribute(UserDetails.class, (Object)this.userController.getCurrentUser());
        }
    }

    private void cleanActiveSessions() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < this.lastCleanTimestamp + 5000L) {
            return;
        }
        this.lastCleanTimestamp = currentTimeMillis;
        ArrayList<VaadinSession> sessionsToRemove = new ArrayList<VaadinSession>();
        for (VaadinSession session : this.activeSessions) {
            if (this.isSessionActive(session)) continue;
            sessionsToRemove.add(session);
        }
        this.activeSessions.removeAll(sessionsToRemove);
    }

    private boolean isSessionActive(VaadinSession session) {
        if (session.isClosing()) {
            return false;
        }
        long lastActiveTimeStamp = System.currentTimeMillis() - (long)(session.getService().getDeploymentConfiguration().getHeartbeatInterval() * 3100);
        for (UI ui : session.getUIs()) {
            if (ui.isClosing() || lastActiveTimeStamp >= ui.getLastHeartbeatTimestamp()) continue;
            return true;
        }
        return false;
    }

    public boolean isUIStillActive(UI ui) {
        this.cleanActiveSessions();
        return !ui.isClosing() && !this.isUITimedOut(ui) && this.activeSessions.contains(ui.getSession());
    }

    private boolean isUITimedOut(UI ui) {
        long lastActiveTimeStamp = System.currentTimeMillis() - (long)(ui.getSession().getService().getDeploymentConfiguration().getHeartbeatInterval() * 3100);
        return ui.getLastHeartbeatTimestamp() < lastActiveTimeStamp;
    }
}

