/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import fr.univlorraine.fwa.controllers.SessionController;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LockController {
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient SessionController sessionController;
    private Map<Object, UI> locks = new ConcurrentHashMap();

    public List<Object> getUILocks(UI ui) {
        ArrayList<Object> uiLocks = new ArrayList<Object>();
        for (Map.Entry entry : this.locks.entrySet()) {
            if (entry.getValue() != ui) continue;
            uiLocks.add(entry.getKey());
        }
        return uiLocks;
    }

    public boolean getLock(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj ne peut \u00eatre null.");
        }
        UI lockUI = (UI)this.locks.get(obj);
        if (lockUI != null && lockUI != UI.getCurrent() && this.sessionController.isUIStillActive(lockUI)) {
            return false;
        }
        this.locks.put(obj, UI.getCurrent());
        return true;
    }

    public boolean getLockOrNotify(Object obj, String msgIfAlreadyLocked) {
        boolean ret = this.getLock(obj);
        if (!ret) {
            if (!StringUtils.hasText((String)msgIfAlreadyLocked)) {
                msgIfAlreadyLocked = this.applicationContext.getMessage("lock.alreadyLocked", new Object[]{this.getUserNameFromLock(obj)}, Locale.getDefault());
            }
            Notification.show((String)msgIfAlreadyLocked, (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
        return ret;
    }

    public void removeLock(Object obj) {
        UI ui = (UI)this.locks.get(obj);
        this.locks.remove(obj);
    }

    public void releaseLock(Object obj) {
        if (this.locks.get(obj) == UI.getCurrent()) {
            this.removeLock(obj);
        }
    }

    public String getUserNameFromLock(Object obj) {
        UI lockUi = (UI)this.locks.get(obj);
        if (lockUi != null) {
            return ((UserDetails)lockUi.getSession().getAttribute(UserDetails.class)).getUsername();
        }
        return null;
    }
}

