/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import fr.univlorraine.fwa.entities.FwaCpt;
import fr.univlorraine.fwa.entities.FwaUti;
import fr.univlorraine.fwa.repositories.FwaCptRepository;
import fr.univlorraine.fwa.repositories.FwaUtiRepository;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FwaUtiController {
    @Resource
    private transient FwaUtiRepository fwaUtiRepository;
    @Resource
    private transient FwaCptRepository fwaCptRepository;
    @Value(value="${base.temoinEnService}")
    private transient char TES;
    @Value(value="${base.temoinPasService}")
    private transient char TPS;
    @Value(value="${encryptionkey}")
    private transient String KEY;
    private final Log logger = LogFactory.getLog(this.getClass());

    public FwaUti findUserInDb(String loginUti) {
        return this.fwaUtiRepository.findOneByLoginUti(loginUti);
    }

    public boolean saveUser(FwaUti user) {
        try {
            this.fwaUtiRepository.save((Object)user);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return false;
        }
    }

    public List<FwaUti> getAllUsers() {
        return this.fwaUtiRepository.findAll();
    }

    public void deleteUser(FwaUti user) {
        List listeCpt = this.fwaCptRepository.findCptForUser(user.getIdUti(), this.KEY);
        for (FwaCpt cpt : listeCpt) {
            this.fwaCptRepository.deleteCpt(cpt.getId().getIdUti(), cpt.getLoginCpt(), cpt.getFwaApp().getCodApp());
        }
        this.fwaUtiRepository.delete((Object)user);
    }
}

