/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import com.vaadin.data.util.BeanItemContainer;
import fr.univlorraine.fwa.controllers.FwaCptController;
import fr.univlorraine.fwa.entities.FwaApp_;
import fr.univlorraine.fwa.entities.FwaMsg;
import fr.univlorraine.fwa.entities.FwaMsg_;
import fr.univlorraine.fwa.repositories.FwaMsgRepository;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FwaMsgController {
    private Logger logger = LoggerFactory.getLogger(FwaCptController.class);
    private static final String DOT = ".";
    @Resource
    private transient FwaMsgRepository fwaMsgRepository;
    @PersistenceContext
    private transient EntityManager entityManager;

    public List<FwaMsg> findActualMsgsForUser(int iduti) {
        return this.fwaMsgRepository.findActual(iduti);
    }

    public List<FwaMsg> findActualMsgsForUserAndApp(int iduti, String codApp) {
        return this.fwaMsgRepository.findActualForApp(iduti, codApp);
    }

    public BeanItemContainer<FwaMsg> getMsgs() {
        BeanItemContainer msgContainer = new BeanItemContainer(FwaMsg.class, (Collection)this.fwaMsgRepository.findAll());
        msgContainer.addNestedContainerProperty(FwaMsg_.fwaApp.getName() + DOT + FwaApp_.libApp.getName());
        msgContainer.sort(new Object[]{FwaMsg_.libMsg.getName()}, new boolean[]{true});
        return msgContainer;
    }

    public boolean save(FwaMsg fwaMsg) {
        try {
            this.fwaMsgRepository.save((Object)fwaMsg);
            return true;
        }
        catch (Exception e) {
            this.logger.error(" erreur a la sauvegarde d'un msg");
            return false;
        }
    }

    public void delete(FwaMsg fwaMsg) {
        this.fwaMsgRepository.delete((Object)fwaMsg);
    }
}

