/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.BeanItemContainer;
import fr.univlorraine.fwa.entities.FwaCpt;
import fr.univlorraine.fwa.entities.FwaCptPk_;
import fr.univlorraine.fwa.entities.FwaCpt_;
import fr.univlorraine.fwa.repositories.FwaCptRepository;
import fr.univlorraine.fwa.utils.FwaPasswordGenerator;
import gouv.education.fwa.services.EncryptionService;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FwaCptController {
    private Logger logger = LoggerFactory.getLogger(FwaCptController.class);
    @Resource
    private transient FwaCptRepository fwaCptRepository;
    @Resource
    private transient FwaPasswordGenerator fwaPasswordGenerator;
    @Value(value="${encryptionkey}")
    private transient String KEY;
    @Value(value="${base.temoinEnService}")
    private transient char TES;

    public String encrypt(String str) {
        return EncryptionService.encrypt((String)str, (String)this.KEY);
    }

    public String decrypt(String str) {
        return EncryptionService.decrypt((String)str, (String)this.KEY);
    }

    public FwaCpt getOneByLoginUti(String loginUti, String loginCpt, String codApp) {
        return this.fwaCptRepository.findOneByLoginUti(this.KEY, loginUti, loginCpt, codApp);
    }

    public BeanItemContainer<FwaCpt> getCptsForUserAndApp(String login, String codApp) {
        BeanItemContainer cptContainer = new BeanItemContainer(FwaCpt.class, (Collection)this.fwaCptRepository.findCptForUserAndApp(this.KEY, login, codApp));
        cptContainer.addNestedContainerProperty(FwaCpt_.id.getName() + "." + FwaCptPk_.loginCpt.getName());
        return cptContainer;
    }

    public BeanItemContainer<FwaCpt> getOpenCptsForUserAndApp(String login, String codApp) {
        BeanItemContainer cptContainer = new BeanItemContainer(FwaCpt.class, (Collection)this.fwaCptRepository.findOpenCptForUserAndApp(this.KEY, login, codApp));
        cptContainer.addNestedContainerProperty(FwaCpt_.id.getName() + "." + FwaCptPk_.loginCpt.getName());
        return cptContainer;
    }

    public void updateAllCpt(char tes, Date dateFin, int idUti, String codApp) {
        if (dateFin != null) {
            this.fwaCptRepository.updateAllCpt(tes, dateFin, idUti, codApp);
        } else {
            this.fwaCptRepository.updateAllCpt(tes, idUti, codApp);
        }
    }

    public void updateAllCpt(Date dateFin, int idUti, String codApp) {
        if (dateFin != null) {
            this.fwaCptRepository.updateAllDateCpt(dateFin, idUti, codApp);
        } else {
            this.fwaCptRepository.updateAllDateCpt(idUti, codApp);
        }
    }

    public void updateAllCpt(char tes, int idUti, String codApp) {
        this.fwaCptRepository.updateAllTesCpt(tes, idUti, codApp);
    }

    public boolean updateCptItem(BeanItem<FwaCpt> cptItem) {
        FwaCpt cpt = (FwaCpt)cptItem.getBean();
        try {
            if (cpt.getDatFinCpt() != null) {
                this.fwaCptRepository.updateCpt(cpt.getPwdCpt(), this.KEY, cpt.getTesCpt(), cpt.getDatFinCpt(), cpt.getId().getIdUti(), cpt.getLoginCpt(), cpt.getId().getCodApp());
            } else {
                this.fwaCptRepository.updateCpt(cpt.getPwdCpt(), this.KEY, cpt.getTesCpt(), cpt.getId().getIdUti(), cpt.getLoginCpt(), cpt.getId().getCodApp());
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error(" erreur a la modification d'un compte");
            return false;
        }
    }

    public void updateDateCpt(FwaCpt fwaCpt) {
        this.fwaCptRepository.update(fwaCpt.getDatDerConCpt(), fwaCpt.getId().getIdUti(), fwaCpt.getId().getLoginCpt(), fwaCpt.getId().getCodApp());
    }

    public boolean saveCptItem(BeanItem<FwaCpt> cptItem) {
        FwaCpt cpt = (FwaCpt)cptItem.getBean();
        try {
            if (cpt.getDatFinCpt() == null) {
                this.fwaCptRepository.insertCpt(cpt.getLoginCpt(), cpt.getId().getIdUti(), cpt.getId().getCodApp(), cpt.getPwdCpt(), this.KEY, cpt.getTesCpt());
            } else {
                this.fwaCptRepository.insertCpt(cpt.getLoginCpt(), cpt.getId().getIdUti(), cpt.getId().getCodApp(), cpt.getPwdCpt(), this.KEY, cpt.getTesCpt(), cpt.getDatFinCpt());
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error(" erreur a la sauvegarde d'un nouveau compte");
            return false;
        }
    }

    public String getPassword(String login) {
        return this.fwaPasswordGenerator.getPassword(login);
    }

    public void deleteCpt(FwaCpt cpt) {
        this.fwaCptRepository.deleteCpt(cpt.getId().getIdUti(), cpt.getLoginCpt(), cpt.getFwaApp().getCodApp());
    }
}

