/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.controllers;

import com.vaadin.data.util.BeanItemContainer;
import fr.univlorraine.fwa.entities.FwaApp;
import fr.univlorraine.fwa.entities.FwaApp_;
import fr.univlorraine.fwa.repositories.FwaAppRepository;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FwaAppController {
    @Resource
    private transient FwaAppRepository fwaAppRepository;
    @PersistenceContext
    private transient EntityManager entityManager;
    @Value(value="${base.temoinEnService}")
    private transient char TES;

    public BeanItemContainer<FwaApp> getApps() {
        BeanItemContainer appContainer = new BeanItemContainer(FwaApp.class, (Collection)this.fwaAppRepository.findAll());
        appContainer.sort(new Object[]{FwaApp_.codApp.getName()}, new boolean[]{true});
        return appContainer;
    }

    public List<FwaApp> getAppForUser(String login) {
        return this.fwaAppRepository.findAppForUser(login);
    }

    public BeanItemContainer<FwaApp> getAppContainerForUser(String login) {
        BeanItemContainer appContainer = new BeanItemContainer(FwaApp.class, (Collection)this.getAppForUser(login));
        appContainer.sort(new Object[]{FwaApp_.codApp.getName()}, new boolean[]{true});
        return appContainer;
    }

    public BeanItemContainer<FwaApp> getOpenAppContainerForUser(String login) {
        BeanItemContainer appContainer = new BeanItemContainer(FwaApp.class, (Collection)this.fwaAppRepository.findOpenAppForUser(login));
        return appContainer;
    }

    public boolean save(FwaApp app) {
        try {
            this.fwaAppRepository.save((Object)app);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

