/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.config;

import fr.univlorraine.fwa.utils.FWAFilterBasedLdapUserSearch;
import fr.univlorraine.fwa.utils.FwaPasswordGenerator;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Resource;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;

@Configuration
@ImportResource(value={"/WEB-INF/spring-security-config.xml"})
public class SecurityConfig {
    @Resource
    private Environment environment;
    @Resource
    public AuthenticationManager authenticationManager;

    @Bean
    public AccessDecisionManager accessDecisionManager() {
        ArrayList<Object> decisionVoters = new ArrayList<Object>();
        RoleVoter roleVoter = new RoleVoter();
        roleVoter.setRolePrefix("");
        decisionVoters.add(roleVoter);
        decisionVoters.add(new AuthenticatedVoter());
        return new AffirmativeBased(decisionVoters);
    }

    @Bean
    public ServiceProperties casServiceProperties() {
        ServiceProperties casServiceProperties = new ServiceProperties();
        casServiceProperties.setService(this.environment.getProperty("app.url") + "/j_spring_cas_security_check");
        casServiceProperties.setSendRenew(false);
        return casServiceProperties;
    }

    @Bean
    public CasAuthenticationFilter casAuthenticationFilter() {
        CasAuthenticationFilter casAuthenticationFilter = new CasAuthenticationFilter();
        casAuthenticationFilter.setAuthenticationManager(this.authenticationManager);
        return casAuthenticationFilter;
    }

    @Bean
    public CasAuthenticationEntryPoint casEntryPoint() {
        CasAuthenticationEntryPoint casEntryPoint = new CasAuthenticationEntryPoint();
        casEntryPoint.setLoginUrl(this.environment.getProperty("cas.url") + "/login");
        casEntryPoint.setServiceProperties(this.casServiceProperties());
        return casEntryPoint;
    }

    @Bean
    public CasAuthenticationProvider casAuthenticationProvider() {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setKey(UUID.randomUUID().toString());
        casAuthenticationProvider.setAuthenticationUserDetailsService((AuthenticationUserDetailsService)new UserDetailsByNameServiceWrapper(this.userDetailsService()));
        casAuthenticationProvider.setServiceProperties(this.casServiceProperties());
        casAuthenticationProvider.setTicketValidator((TicketValidator)new Cas20ServiceTicketValidator(this.environment.getProperty("cas.url")));
        return casAuthenticationProvider;
    }

    @Bean
    public SingleSignOutFilter singleSignOutFilter() {
        return new SingleSignOutFilter();
    }

    @Bean
    public UserDetailsService userDetailsService() {
        LdapUserDetailsService ldapUserDetailsService = new LdapUserDetailsService(this.ldapUserSearch());
        return ldapUserDetailsService;
    }

    @Bean
    public LdapContextSource ldapServer() {
        LdapContextSource ldapContextSource = new LdapContextSource();
        ldapContextSource.setUrl(this.environment.getProperty("ldap.url"));
        ldapContextSource.setUserDn(this.environment.getProperty("ldap.root"));
        ldapContextSource.setPassword(this.environment.getProperty("ldap.password"));
        return ldapContextSource;
    }

    @Bean
    public LdapUserSearch ldapUserSearch() {
        return new FWAFilterBasedLdapUserSearch(this.environment.getProperty("ldap.dc"), this.environment.getProperty("ldap.ou"), "(&(" + this.environment.getProperty("ldap.uid") + "={0}))", (BaseLdapPathContextSource)this.ldapServer());
    }

    @Bean
    public LdapTemplate ldapTemplate() {
        return new LdapTemplate((ContextSource)this.ldapServer());
    }

    @Bean
    public FwaPasswordGenerator fwaPasswordGenerator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = this.environment.getProperty("fwa.pwdgenerator.class") != null ? this.environment.getProperty("fwa.pwdgenerator.class") : "fr.univlorraine.fwa.utils.FwaPasswordGeneratorDefImpl";
        Class<?> c = Class.forName(className);
        return (FwaPasswordGenerator)c.newInstance();
    }
}

