/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa.config;

import fr.univlorraine.fwa.entities.FwaAdm;
import fr.univlorraine.fwa.repositories.FwaAdmRepository;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(mode=AdviceMode.ASPECTJ)
@EnableJpaRepositories(basePackageClasses={FwaAdmRepository.class})
public class JpaConfig {
    public static final String PERSISTENCE_UNIT_NAME = "pun-jpa";
    private static final String DB_ORACLE = "ORACLE";
    @Value(value="${databaseType}")
    private transient String dbType;

    @Bean
    public DataSource dataSource() {
        JndiDataSourceLookup dsLookup = new JndiDataSourceLookup();
        return dsLookup.getDataSource("java:/comp/env/jdbc/db");
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        localContainerEntityManagerFactoryBean.setPersistenceUnitName(PERSISTENCE_UNIT_NAME);
        localContainerEntityManagerFactoryBean.setPackagesToScan(new String[]{FwaAdm.class.getPackage().getName()});
        localContainerEntityManagerFactoryBean.setDataSource(this.dataSource());
        localContainerEntityManagerFactoryBean.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.enable_lazy_load_no_trans", (Object)true);
        localContainerEntityManagerFactoryBean.setJpaProperties(jpaProperties);
        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
        hibernateJpaVendorAdapter.setGenerateDdl(false);
        hibernateJpaVendorAdapter.setShowSql(false);
        if (DB_ORACLE.equals(this.dbType)) {
            hibernateJpaVendorAdapter.setDatabase(Database.ORACLE);
        } else {
            hibernateJpaVendorAdapter.setDatabase(Database.MYSQL);
        }
        localContainerEntityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)hibernateJpaVendorAdapter);
        return localContainerEntityManagerFactoryBean;
    }

    @Bean
    public JpaTransactionManager transactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }
}

