/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.fwa;

import com.vaadin.annotations.StyleSheet;
import com.vaadin.annotations.Theme;
import com.vaadin.event.LayoutEvents;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.BrowserWindowOpener;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.ResourceReference;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import fr.univlorraine.fwa.controllers.FwaAdmController;
import fr.univlorraine.fwa.controllers.MainController;
import fr.univlorraine.fwa.controllers.SessionController;
import fr.univlorraine.fwa.controllers.UserController;
import fr.univlorraine.fwa.views.ConnexionView;
import fr.univlorraine.tools.vaadin.GoogleAnalyticsTracker;
import fr.univlorraine.tools.vaadin.SpringErrorViewProvider;
import fr.univlorraine.vaadin.themes.ThemeBar;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import ru.xpoft.vaadin.DiscoveryNavigator;
import ru.xpoft.vaadin.ViewCacheContainer;

@Component
@Scope(value="prototype")
@Theme(value="univ-lorraine")
@StyleSheet(value={"mainView.css"})
public class MainUI
extends UI {
    private static final long serialVersionUID = 1L;
    @Resource
    private transient ApplicationContext applicationContext;
    @Resource
    private transient MainController mainController;
    @Resource
    private transient UserController userController;
    @Resource
    private transient FwaAdmController fwaAdmController;
    @Resource
    private transient SessionController sessionController;
    @Value(value="${app.name}")
    private transient String appName;
    @Value(value="${app.version}")
    private transient String appVersion;
    @Value(value="${analytics.account:#{null}}")
    private transient String analyticsAccount;
    @Resource
    private Environment environment;
    private Navigator navigator;
    private GoogleAnalyticsTracker googleAnalyticsTracker = new GoogleAnalyticsTracker((UI)this);

    protected void init(VaadinRequest request) {
        BrowserWindowOpener bwoAssistance;
        Button btnAssistanceApo;
        BrowserWindowOpener bwoDoc;
        Button btnDoc;
        this.getPage().setTitle(this.appName);
        VerticalLayout display = new VerticalLayout();
        display.setSizeFull();
        display.setDefaultComponentAlignment(Alignment.TOP_CENTER);
        this.navigator = new DiscoveryNavigator((UI)this, (ComponentContainer)display);
        this.navigator.setErrorProvider((ViewProvider)new SpringErrorViewProvider(ConnexionView.class, (ViewCacheContainer)((DiscoveryNavigator)this.navigator)));
        this.navigator.addViewChangeListener((ViewChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        ThemeBar themeBar = new ThemeBar("true".equals(request.getParameter("hideTitle")) ? "" : this.appName, this.appVersion);
        themeBar.addTitleClickListener((LayoutEvents.LayoutClickListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.fwaAdmController.isAdmin(this.userController.getCurrentUserName())) {
            Button adminMenuButton = themeBar.addButton(this.applicationContext.getMessage("admin", null, Locale.getDefault()), null);
            themeBar.addSubButton(adminMenuButton, "Connexion", "connexion");
            themeBar.addSubButton(adminMenuButton, " Utilisateurs", "UserView");
            themeBar.addSubButton(adminMenuButton, "Applications", "applicationView");
            themeBar.addSubButton(adminMenuButton, "Messages", "messageView");
        } else {
            themeBar.addButton(this.applicationContext.getMessage("connexionView.connexionBtn", null, Locale.getDefault()), "connexion");
        }
        if (this.environment.containsProperty("doc.url.Apogee") && this.environment.containsProperty("doc.url.Harpege")) {
            btnDoc = themeBar.addButton(this.applicationContext.getMessage("linkDoc", null, Locale.getDefault()), null);
            btnDoc.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.environment.containsProperty("doc.url.Apogee")) {
            btnDoc = themeBar.addButton(this.applicationContext.getMessage("linkDoc", null, Locale.getDefault()), null);
            bwoDoc = new BrowserWindowOpener(this.environment.getProperty("doc.url.Apogee"));
            bwoDoc.extend((AbstractComponent)btnDoc);
        } else if (this.environment.containsProperty("doc.url.Harpege")) {
            btnDoc = themeBar.addButton(this.applicationContext.getMessage("linkDoc", null, Locale.getDefault()), null);
            bwoDoc = new BrowserWindowOpener(this.environment.getProperty("doc.url.Harpege"));
            bwoDoc.extend((AbstractComponent)btnDoc);
        }
        if (this.environment.containsProperty("assistanceApo.url") && this.environment.containsProperty("assistanceHarp.url")) {
            btnAssistanceApo = themeBar.addButton(this.applicationContext.getMessage("linkAssistance", null, Locale.getDefault()), null);
            btnAssistanceApo.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.environment.containsProperty("assistanceApo.url")) {
            btnAssistanceApo = themeBar.addButton(this.applicationContext.getMessage("linkAssistance", null, Locale.getDefault()), null);
            bwoAssistance = new BrowserWindowOpener(this.environment.getProperty("assistanceApo.url"));
            bwoAssistance.extend((AbstractComponent)btnAssistanceApo);
        } else if (this.environment.containsProperty("assistanceHarp.url")) {
            btnAssistanceApo = themeBar.addButton(this.applicationContext.getMessage("linkAssistance", null, Locale.getDefault()), null);
            bwoAssistance = new BrowserWindowOpener(this.environment.getProperty("assistanceHarp.url"));
            bwoAssistance.extend((AbstractComponent)btnAssistanceApo);
        }
        String isAfficherBouton = this.environment.getProperty("cas.deconnexion.afficher");
        if (isAfficherBouton == null || isAfficherBouton.isEmpty() || !isAfficherBouton.equalsIgnoreCase("false")) {
            Button btnDeconnexion = themeBar.addButton(this.applicationContext.getMessage("linkDeconnexion", null, Locale.getDefault()), null);
            ExternalResource res = new ExternalResource(this.environment.getProperty("cas.deconnexion.url"));
            ResourceReference resourceReference = ResourceReference.create((com.vaadin.server.Resource)res, (ClientConnector)themeBar, (String)"Deconnexion");
            btnDeconnexion.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setSizeFull();
        mainLayout.addComponent((com.vaadin.ui.Component)themeBar);
        mainLayout.addComponent((com.vaadin.ui.Component)display);
        mainLayout.setExpandRatio((com.vaadin.ui.Component)display, 1.0f);
        this.setContent((com.vaadin.ui.Component)mainLayout);
        this.googleAnalyticsTracker.setAccount(this.analyticsAccount);
        if (!this.getSession().getService().getDeploymentConfiguration().isProductionMode()) {
            this.googleAnalyticsTracker.setDomainName("none");
        }
        this.googleAnalyticsTracker.trackNavigator(this.navigator);
        this.sessionController.registerSession(this.getSession());
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    public GoogleAnalyticsTracker getGoogleAnalyticsTracker() {
        return this.googleAnalyticsTracker;
    }

    static /* synthetic */ MainController access$000(MainUI x0) {
        return x0.mainController;
    }

    static {
        SLF4JBridgeHandler.install();
    }
}

