/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.apowsutils;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang3.StringUtils;

public class WSUtils {
    private static String propertyFilePath;
    private static Properties properties;
    private static Map<String, String> headers;
    public static final String PROVIDER_INTERFACE_SUFFIXE = "Service";
    public static final String PROVIDER_SERVICE_SUFFIXE = "ServiceInterface";
    public static final String PROVIDER_METHOD = "get";
    public static final String PROPERTY_FILE = "configUrlServices.properties";
    private static final String API_HEADER_PREFIXE = "api.header";
    private static final String URL_SUFFIXE = "urlService";
    private static final String WS_USER_PROPERTY = "apo-ws-user";
    private static final String WS_PWD_PROPERTY = "apo-ws-pwd";
    private static final String WS_SSL_MODE_PROPERTY = "WS_SSL_MODE";
    private static final String WS_SSL_CERTIF_STORE_PATH_PROPERTY = "WS_KEY_STORE_PATH";
    private static final String WS_SSL_KEY_STORE_PATH_PROPERTY = "WS_CERTIF_STORE_PATH";
    private static final String WS_SSL_KEY_PASS_PROPERTY = "WS_KEY_PASS";
    private static final String WS_SSL_KEY_TYPE_PROPERTY = "WS_KEY_TYPE";
    public static final String BUNDLE_VALUE_SEPARATOR = " ; ";

    static {
        properties = new Properties();
        headers = new HashMap<String, String>();
    }

    public static void setPropertyFilePath(String newPropertyFilePath) {
        propertyFilePath = newPropertyFilePath;
    }

    public static void resetProperties() {
        properties.clear();
    }

    public static void addHeader(String property, String value) {
        headers.put(property, value);
    }

    public static String getUrlWS(String service) {
        return WSUtils.getBundleVal(String.valueOf(service) + "." + URL_SUFFIXE);
    }

    private static Properties getProperties() {
        if (properties.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)propertyFilePath)) {
                try {
                    FileInputStream file = Files.isDirectory(Paths.get(propertyFilePath, new String[0]), new LinkOption[0]) ? new FileInputStream(String.valueOf(propertyFilePath) + PROPERTY_FILE) : new FileInputStream(propertyFilePath);
                    properties.load(file);
                    file.close();
                    return properties;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                properties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTY_FILE));
                return properties;
            }
            catch (Exception exception) {
                throw new RuntimeException("Impossible de charger le fichier configUrlServices, ajoutez le dans le dossier ressources ou ajoutez le param\u00e8tre configUrlServices.location au lancement de la JVM");
            }
        }
        return properties;
    }

    private static String getBundleVal(String key) {
        return WSUtils.getProperties().getProperty(key);
    }

    private static List<String> getBundleVals(String key) {
        return new ArrayList<String>(Arrays.asList(WSUtils.getBundleVal(key).split(BUNDLE_VALUE_SEPARATOR)));
    }

    public static void configureService(BindingProvider bp, String service) {
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", WSUtils.getBundleVal(String.valueOf(service) + "." + URL_SUFFIXE));
        Map<String, List<String>> headersMap = WSUtils.getServiceHeaders(service);
        if (!headersMap.isEmpty()) {
            bp.getRequestContext().put("javax.xml.ws.http.request.headers", headersMap);
        }
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", WSUtils.getAuthProperty(service, WS_USER_PROPERTY));
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", WSUtils.getAuthProperty(service, WS_PWD_PROPERTY));
        String sslMode = properties.getProperty(WS_SSL_MODE_PROPERTY);
        if ("true".equalsIgnoreCase(sslMode)) {
            System.setProperty("javax.net.ssl.trustStore", properties.getProperty(WS_SSL_CERTIF_STORE_PATH_PROPERTY));
            System.setProperty("javax.net.ssl.keyStore", properties.getProperty(WS_SSL_KEY_STORE_PATH_PROPERTY));
            System.setProperty("javax.net.ssl.keyStorePassword", properties.getProperty(WS_SSL_KEY_PASS_PROPERTY));
            System.setProperty("javax.net.ssl.keyStoreType", properties.getProperty(WS_SSL_KEY_TYPE_PROPERTY));
        }
    }

    public static Map<String, List<String>> getServiceHeaders(String service) {
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
        headers.forEach((key, value) -> {
            if (key.startsWith(service)) {
                String headerName = key.substring(service.length() + 1);
                headersMap.put(headerName, Arrays.asList(value));
            }
        });
        String serviceHeaderPrefixService = "api.header." + service;
        for (Object keyO : WSUtils.getProperties().keySet()) {
            String key2 = (String)keyO;
            if (!key2.startsWith(serviceHeaderPrefixService)) continue;
            String headerName = key2.substring(serviceHeaderPrefixService.length() + 1);
            List<String> headerValues = WSUtils.getBundleVals(key2);
            headersMap.put(headerName, headerValues);
        }
        return headersMap;
    }

    private static String getAuthProperty(String service, String property) {
        try {
            return properties.getProperty(String.valueOf(service) + "." + property);
        }
        catch (Exception e) {
            return null;
        }
    }
}

