/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.apowsutils;

import fr.univlorraine.apowsutils.WSUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.ws.BindingProvider;

public class ServiceProvider {
    public static <T> T getService(Class<T> serviceClazz) {
        try {
            if (serviceClazz == null) {
                throw new RuntimeException("La class du service ne peut pas etre null");
            }
            String classNameProvider = String.valueOf(serviceClazz.getName()) + "Service";
            String serviceName = serviceClazz.getSimpleName().replaceAll("ServiceInterface", "");
            String methodName = "get" + serviceName;
            String serviceNameLower = String.valueOf(serviceName.substring(0, 1).toLowerCase()) + serviceName.substring(1);
            URL wsdlLocation = new URL(WSUtils.getWsdlLocation(serviceNameLower));
            Class<?> serviceInterfaceClazz = Class.forName(classNameProvider);
            Object service = serviceInterfaceClazz.getMethod(methodName, new Class[0]).invoke(serviceInterfaceClazz.getConstructor(URL.class).newInstance(wsdlLocation), new Object[0]);
            WSUtils.configureService((BindingProvider)service, serviceNameLower);
            return (T)service;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            throw new RuntimeException("Impossible de charger le service " + serviceClazz.getSimpleName(), e);
        }
    }
}

