package fr.univlorraine.apowsclient.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;

import javax.xml.bind.DatatypeConverter;

public class DateAdapter {

	private DateAdapter() {
	}

	public static String printDate(final LocalDate localDate) {
		final Calendar calendar = Calendar.getInstance();
		calendar.clear();
		calendar.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
		return DatatypeConverter.printDateTime(calendar);
	}

	public static String printDateTime(final LocalDateTime localDateTime) {
		final Calendar calendar = Calendar.getInstance();
		calendar.clear();
		calendar.set(localDateTime.getYear(),
			localDateTime.getMonthValue() - 1,
			localDateTime.getDayOfMonth(),
			localDateTime.getHour(),
			localDateTime.getMinute(),
			localDateTime.getSecond());
		return DatatypeConverter.printDateTime(calendar);
	}

	public static LocalDate parseDate(final String xmlDate) {
		return DatatypeConverter.parseDate(xmlDate)
			.getTime()
			.toInstant()
			.atZone(ZoneId.systemDefault())
			.toLocalDate();
	}

	public static LocalDateTime parseDateTime(final String xmlDateTime) {
		return DatatypeConverter.parseDate(xmlDateTime)
			.getTime()
			.toInstant()
			.atZone(ZoneId.systemDefault())
			.toLocalDateTime();
	}

}
