package fr.univlorraine.apowsclient.utils;

import javax.xml.ws.BindingProvider;

import fr.univlorraine.apowsclient.administratif.AdministratifMetierServiceInterface;
import fr.univlorraine.apowsclient.administratif.AdministratifMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.couvertureSocial.CouvertureSocialeMetierServiceInterface;
import fr.univlorraine.apowsclient.couvertureSocial.CouvertureSocialeMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.creationSE.CreationSEMetierServiceInterface;
import fr.univlorraine.apowsclient.creationSE.CreationSEMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.droit.DroitMetierServiceInterface;
import fr.univlorraine.apowsclient.droit.DroitMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.etablissement.EtablissementMetierServiceInterface;
import fr.univlorraine.apowsclient.etablissement.EtablissementMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.etudiant.EtudiantMetierServiceInterface;
import fr.univlorraine.apowsclient.etudiant.EtudiantMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.geographie.GeographieMetierServiceInterface;
import fr.univlorraine.apowsclient.geographie.GeographieMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.infosEtu.InfosEtuMetierServiceInterface;
import fr.univlorraine.apowsclient.infosEtu.InfosEtuMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.interdit.InterditMetierServiceInterface;
import fr.univlorraine.apowsclient.interdit.InterditMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.laissezPasser.LaissezPasserMetierServiceInterface;
import fr.univlorraine.apowsclient.laissezPasser.LaissezPasserMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.offreFormation.OffreFormationMetierServiceInterface;
import fr.univlorraine.apowsclient.offreFormation.OffreFormationMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.opi.OpiMetierServiceInterface;
import fr.univlorraine.apowsclient.opi.OpiMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.pedagogique.PedagogiqueMetierServiceInterface;
import fr.univlorraine.apowsclient.pedagogique.PedagogiqueMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.pjOpi.PjOpiMetierServiceInterface;
import fr.univlorraine.apowsclient.pjOpi.PjOpiMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.profession.ProfessionMetierServiceInterface;
import fr.univlorraine.apowsclient.profession.ProfessionMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.referentiel.ReferentielMetierServiceInterface;
import fr.univlorraine.apowsclient.referentiel.ReferentielMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.referentielPR.ReferentielPRMetierServiceInterface;
import fr.univlorraine.apowsclient.referentielPR.ReferentielPRMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.scolarite.ScolariteMetierServiceInterface;
import fr.univlorraine.apowsclient.scolarite.ScolariteMetierServiceInterfaceService;
import fr.univlorraine.apowsclient.these.TheseMetierServiceInterface;
import fr.univlorraine.apowsclient.these.TheseMetierServiceInterfaceService;

/**
 * Provider de service WS
 * @author Kevin Hergalant
 */
public class ServiceProvider {

	/**
	 * @return le service administratif
	 */
	public static AdministratifMetierServiceInterface getAdministratifService() {
		final AdministratifMetierServiceInterfaceService serviceInterface = new AdministratifMetierServiceInterfaceService();
		final AdministratifMetierServiceInterface service = serviceInterface.getAdministratifMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.ADMINISTRATIF_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service couvertureSociale
	 */
	public static CouvertureSocialeMetierServiceInterface getCouvertureSocialeService() {
		final CouvertureSocialeMetierServiceInterfaceService serviceInterface = new CouvertureSocialeMetierServiceInterfaceService();
		final CouvertureSocialeMetierServiceInterface service = serviceInterface.getCouvertureSocialeMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.COUVERTURE_SOCIALE_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service creationSE
	 */
	public static CreationSEMetierServiceInterface getCreationSEService() {
		final CreationSEMetierServiceInterfaceService serviceInterface = new CreationSEMetierServiceInterfaceService();
		final CreationSEMetierServiceInterface service = serviceInterface.getCreationSEMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.CREATIONSE_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service droit
	 */
	public static DroitMetierServiceInterface getDroitService() {
		final DroitMetierServiceInterfaceService serviceInterface = new DroitMetierServiceInterfaceService();
		final DroitMetierServiceInterface service = serviceInterface.getDroitMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.DROIT_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service etablissement
	 */
	public static EtablissementMetierServiceInterface getEtablissementService() {
		final EtablissementMetierServiceInterfaceService serviceInterface = new EtablissementMetierServiceInterfaceService();
		final EtablissementMetierServiceInterface service = serviceInterface.getEtablissementMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.ETABLISSEMENT_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service etudiant
	 */
	public static EtudiantMetierServiceInterface getEtudiantService() {
		final EtudiantMetierServiceInterfaceService serviceInterface = new EtudiantMetierServiceInterfaceService();
		final EtudiantMetierServiceInterface service = serviceInterface.getEtudiantMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.ETUDIANT_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service geographie
	 */
	public static GeographieMetierServiceInterface getGeographieService() {
		final GeographieMetierServiceInterfaceService serviceInterface = new GeographieMetierServiceInterfaceService();
		final GeographieMetierServiceInterface service = serviceInterface.getGeographieMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.GEOGRAPHIE_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service infosEtu
	 */
	public static InfosEtuMetierServiceInterface getInfosEtuService() {
		final InfosEtuMetierServiceInterfaceService serviceInterface = new InfosEtuMetierServiceInterfaceService();
		final InfosEtuMetierServiceInterface service = serviceInterface.getInfosEtuMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.INFOS_ETU_SOCIALE_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service infosEtu
	 */
	public static InterditMetierServiceInterface getInterditService() {
		final InterditMetierServiceInterfaceService serviceInterface = new InterditMetierServiceInterfaceService();
		final InterditMetierServiceInterface service = serviceInterface.getInterditMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.INTERDIT_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service laissezPasser
	 */
	public static LaissezPasserMetierServiceInterface getLaissezPasserService() {
		final LaissezPasserMetierServiceInterfaceService serviceInterface = new LaissezPasserMetierServiceInterfaceService();
		final LaissezPasserMetierServiceInterface service = serviceInterface.getLaissezPasserMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.LAISSEZ_PASSER_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service offreFormation
	 */
	public static OffreFormationMetierServiceInterface getOffreFormationService() {
		final OffreFormationMetierServiceInterfaceService serviceInterface = new OffreFormationMetierServiceInterfaceService();
		final OffreFormationMetierServiceInterface service = serviceInterface.getOffreFormationMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.OFFRE_FORMATION_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service opi
	 */
	public static OpiMetierServiceInterface getOpiService() {
		final OpiMetierServiceInterfaceService serviceInterface = new OpiMetierServiceInterfaceService();
		final OpiMetierServiceInterface service = serviceInterface.getOpiMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.OPI_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service pedagogique
	 */
	public static PedagogiqueMetierServiceInterface getPedagogiqueService() {
		final PedagogiqueMetierServiceInterfaceService serviceInterface = new PedagogiqueMetierServiceInterfaceService();
		final PedagogiqueMetierServiceInterface service = serviceInterface.getPedagogiqueMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.PEDAGOGIQUE_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service pjOpi
	 */
	public static PjOpiMetierServiceInterface getPjOpiService() {
		final PjOpiMetierServiceInterfaceService serviceInterface = new PjOpiMetierServiceInterfaceService();
		final PjOpiMetierServiceInterface service = serviceInterface.getPjOpiMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.PJ_OPI_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service profession
	 */
	public static ProfessionMetierServiceInterface getProfessionService() {
		final ProfessionMetierServiceInterfaceService serviceInterface = new ProfessionMetierServiceInterfaceService();
		final ProfessionMetierServiceInterface service = serviceInterface.getProfessionMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.PROFESSION_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service referentiel
	 */
	public static ReferentielMetierServiceInterface getReferentielService() {
		final ReferentielMetierServiceInterfaceService serviceInterface = new ReferentielMetierServiceInterfaceService();
		final ReferentielMetierServiceInterface service = serviceInterface.getReferentielMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.REFERENTIEL_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service referentielPR
	 */
	public static ReferentielPRMetierServiceInterface getReferentielPRService() {
		final ReferentielPRMetierServiceInterfaceService serviceInterface = new ReferentielPRMetierServiceInterfaceService();
		final ReferentielPRMetierServiceInterface service = serviceInterface.getReferentielPRMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.REFERENTIEL_PR_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service scolarite
	 */
	public static ScolariteMetierServiceInterface getScolariteService() {
		final ScolariteMetierServiceInterfaceService serviceInterface = new ScolariteMetierServiceInterfaceService();
		final ScolariteMetierServiceInterface service = serviceInterface.getScolariteMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.SCOLARITE_METIER_SERVICE_NAME);
		return service;
	}

	/**
	 * @return le service these
	 */
	public static TheseMetierServiceInterface getTheseService() {
		final TheseMetierServiceInterfaceService serviceInterface = new TheseMetierServiceInterfaceService();
		final TheseMetierServiceInterface service = serviceInterface.getTheseMetier();
		WSUtils.configureService((BindingProvider) service, WSUtils.THESE_METIER_SERVICE_NAME);
		return service;
	}

}
