package fr.univlorraine.apowsclient.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;

/**
 * Utilitaire pour les WS Apogee.
 * @author Charlie Dubois
 */
public class WSUtils {

	public static final String TEM_EN_SERV_OK = "O";

	public static final String TEM_EN_SERV_KO = "N";

	public static final String WSDL_EXT = "?wsdl";

	/* Fichier du bundle */
	private final static String BUNDLE_FILE = "configUrlServices";

	/* Prefixe des header */
	private final static String API_HEADER_PREFIXE = "api.header";

	/* Suffixe des url services */
	private final static String URL_SUFFIXE = "urlService";

	/* Authentif Apogée */
	private final static String WS_USER_PROPERTY = "apo-ws-user";
	private final static String WS_PWD_PROPERTY = "apo-ws-pwd";

	/* Services */
	public static final String ADMINISTRATIF_METIER_SERVICE_NAME = "administratifMetier";
	public static final String COUVERTURE_SOCIALE_METIER_SERVICE_NAME = "couvertureSocialeMetier";
	public static final String CREATIONSE_METIER_SERVICE_NAME = "creationSEMetier";
	public static final String DROIT_METIER_SERVICE_NAME = "droitMetier";
	public static final String ETABLISSEMENT_METIER_SERVICE_NAME = "etablissementMetier";
	public static final String ETUDIANT_METIER_SERVICE_NAME = "etudiantMetier";
	public static final String GEOGRAPHIE_METIER_SERVICE_NAME = "geographieMetier";
	public static final String INFOS_ETU_SOCIALE_METIER_SERVICE_NAME = "infosEtuMetier";
	public static final String LAISSEZ_PASSER_METIER_SERVICE_NAME = "laissezPasserMetier";
	public static final String OFFRE_FORMATION_METIER_SERVICE_NAME = "offreFormationMetier";
	public static final String OPI_METIER_SERVICE_NAME = "opiMetier";
	public static final String PEDAGOGIQUE_METIER_SERVICE_NAME = "pedagogiqueMetier";
	public static final String PJ_OPI_METIER_SERVICE_NAME = "pjOpiMetier";
	public static final String PROFESSION_METIER_SERVICE_NAME = "professionMetier";
	public static final String REFERENTIEL_METIER_SERVICE_NAME = "referentielMetier";
	public static final String REFERENTIEL_PR_METIER_SERVICE_NAME = "referentielPRMetier";
	public static final String SCOLARITE_METIER_SERVICE_NAME = "scolariteMetier";
	public static final String THESE_METIER_SERVICE_NAME = "theseMetier";

	public static final String BUNDLE_VALUE_SEPARATOR = " ; ";

	/**
	 * @param  key
	 * @return     la valeur d'une key de configUrlServices.properties
	 */
	private static String getBundleVal(final String key) {
		return ResourceBundle.getBundle(BUNDLE_FILE).getString(key);
	}

	/**
	 * @param  key
	 * @return     les valeurs d'une key de configUrlServices.properties
	 */
	private static List<String> getBundleVals(final String key) {
		return new ArrayList<>(Arrays.asList(getBundleVal(key).split(BUNDLE_VALUE_SEPARATOR)));
	}

	/**
	 * Charge l'url pour injecter les paramètres (service et header)
	 * @param bp
	 * @param service
	 */
	public static void configureService(final BindingProvider bp, final String service) {
		/* On passe le l'url du service dans ENDPOINT_ADDRESS_PROPERTY */
		bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, getBundleVal(service + "." + URL_SUFFIXE));

		final Map<String, List<String>> headersMap = getServiceHeaders(service);
		/* Si des headers sont présents pour ce service, on les ajoute dans HTTP_REQUEST_HEADERS */
		if (!headersMap.isEmpty()) {
			bp.getRequestContext()
				.put(MessageContext.HTTP_REQUEST_HEADERS, headersMap);
		}

		/* Ajout user/mdp apogée */
		bp.getRequestContext().put(BindingProvider.USERNAME_PROPERTY, getAuthProperty(service, WS_USER_PROPERTY));
		bp.getRequestContext().put(BindingProvider.PASSWORD_PROPERTY, getAuthProperty(service, WS_PWD_PROPERTY));
	}

	/**
	 * @param  nom du service
	 * @return     la liste des headers du service et leurs valeurs
	 */
	private static Map<String, List<String>> getServiceHeaders(final String service) {

		final Map<String, List<String>> headersMap = new HashMap<>();

		//Calcul du préfixe définissant les headers du service
		final String serviceHeaderPrefixService = API_HEADER_PREFIXE + "." + service;

		/* Pour chaque clé du fichier de config */
		for (final String key : ResourceBundle.getBundle(BUNDLE_FILE).keySet()) {

			//Si la clé comemnce par le préfixe définissant les headers du service
			if (key.startsWith(serviceHeaderPrefixService)) {

				//Récupération du nom header
				final String headerName = key.substring(serviceHeaderPrefixService.length() + 1);

				//Récupération des valeurs du header
				final List<String> headerValues = getBundleVals(key);

				//Ajout dans la map
				headersMap.put(headerName, headerValues);

			}
		}

		//On retourne la map
		return headersMap;

	}

	/**
	 * @param  service
	 * @param  property
	 * @return          la property pour l'authentif apogée
	 */
	private static String getAuthProperty(final String service, final String property) {
		try {
			return ResourceBundle.getBundle(BUNDLE_FILE).getString(service + "." + property);
		} catch (final Exception e) {
			return null;
		}
	}
}
