/*
 * Decompiled with CFR 0.152.
 */
package fr.univlorraine.apowsclient.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.ws.BindingProvider;

public class WSUtils {
    public static final String TEM_EN_SERV_OK = "O";
    public static final String TEM_EN_SERV_KO = "N";
    public static final String WSDL_EXT = "?wsdl";
    private static final String BUNDLE_FILE = "configUrlServices";
    private static final String API_HEADER_PREFIXE = "api.header";
    private static final String URL_SUFFIXE = "urlService";
    private static final String WS_USER_PROPERTY = "apo-ws-user";
    private static final String WS_PWD_PROPERTY = "apo-ws-pwd";
    public static final String ADMINISTRATIF_METIER_SERVICE_NAME = "administratifMetier";
    public static final String COUVERTURE_SOCIALE_METIER_SERVICE_NAME = "couvertureSocialeMetier";
    public static final String CREATIONSE_METIER_SERVICE_NAME = "creationSEMetier";
    public static final String DROIT_METIER_SERVICE_NAME = "droitMetier";
    public static final String ETABLISSEMENT_METIER_SERVICE_NAME = "etablissementMetier";
    public static final String ETUDIANT_METIER_SERVICE_NAME = "etudiantMetier";
    public static final String GEOGRAPHIE_METIER_SERVICE_NAME = "geographieMetier";
    public static final String INFOS_ETU_SOCIALE_METIER_SERVICE_NAME = "infosEtuMetier";
    public static final String LAISSEZ_PASSER_METIER_SERVICE_NAME = "laissezPasserMetier";
    public static final String OFFRE_FORMATION_METIER_SERVICE_NAME = "offreFormationMetier";
    public static final String OPI_METIER_SERVICE_NAME = "opiMetier";
    public static final String PEDAGOGIQUE_METIER_SERVICE_NAME = "pedagogiqueMetier";
    public static final String PJ_OPI_METIER_SERVICE_NAME = "pjOpiMetier";
    public static final String PROFESSION_METIER_SERVICE_NAME = "professionMetier";
    public static final String REFERENTIEL_METIER_SERVICE_NAME = "referentielMetier";
    public static final String REFERENTIEL_PR_METIER_SERVICE_NAME = "referentielPRMetier";
    public static final String SCOLARITE_METIER_SERVICE_NAME = "scolariteMetier";
    public static final String THESE_METIER_SERVICE_NAME = "theseMetier";
    public static final String BUNDLE_VALUE_SEPARATOR = " ; ";

    private static String getBundleVal(String key) {
        return ResourceBundle.getBundle(BUNDLE_FILE).getString(key);
    }

    private static List<String> getBundleVals(String key) {
        return new ArrayList<String>(Arrays.asList(WSUtils.getBundleVal(key).split(BUNDLE_VALUE_SEPARATOR)));
    }

    public static void configureService(BindingProvider bp, String service) {
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", WSUtils.getBundleVal(service + "." + URL_SUFFIXE));
        Map<String, List<String>> headersMap = WSUtils.getServiceHeaders(service);
        if (!headersMap.isEmpty()) {
            bp.getRequestContext().put("javax.xml.ws.http.request.headers", headersMap);
        }
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", WSUtils.getAuthProperty(service, WS_USER_PROPERTY));
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", WSUtils.getAuthProperty(service, WS_PWD_PROPERTY));
    }

    private static Map<String, List<String>> getServiceHeaders(String service) {
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
        String serviceHeaderPrefixService = "api.header." + service;
        for (String key : ResourceBundle.getBundle(BUNDLE_FILE).keySet()) {
            if (!key.startsWith(serviceHeaderPrefixService)) continue;
            String headerName = key.substring(serviceHeaderPrefixService.length() + 1);
            List<String> headerValues = WSUtils.getBundleVals(key);
            headersMap.put(headerName, headerValues);
        }
        return headersMap;
    }

    private static String getAuthProperty(String service, String property) {
        try {
            return ResourceBundle.getBundle(BUNDLE_FILE).getString(service + "." + property);
        }
        catch (Exception e) {
            return null;
        }
    }
}

